#include <QApplication>
#include <QDebug>
#include <QMessageBox>
#include <QWidget>
#include <QVBoxLayout>
#include <QLabel>

#ifdef Q_OS_WIN
#include <windows.h>
#include <io.h>
#include <fcntl.h>
#endif

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    
    // 设置Qt日志输出格式，不弹出单独的控制台窗口
    qSetMessagePattern("[%{time yyyyMMdd h:mm:ss.zzz t}] %{type}: %{message}");
    
    qDebug() << "=== Test Application Starting ===";
    qDebug() << "Debug output enabled";
    
    // 创建一个简单的窗口
    QWidget window;
    window.setWindowTitle("Test Window");
    window.resize(400, 300);
    
    QVBoxLayout* layout = new QVBoxLayout(&window);
    QLabel* label = new QLabel("Test Application Running", &window);
    layout->addWidget(label);
    
    qDebug() << "Showing window...";
    window.show();
    
    qDebug() << "Window visible:" << window.isVisible();
    qDebug() << "Window geometry:" << window.geometry();
    
    qDebug() << "Entering Qt event loop...";
    int result = a.exec();
    qDebug() << "Qt event loop exited with code:" << result;
    
    return result;
}