@echo off
setlocal enabledelayedexpansion

echo ========================================
echo Qt Environment Setup for Windows
echo ========================================

:: 常见的Qt安装路径
set "QT_PATHS=C:\Qt\6.8.1\msvc2022_64;C:\Qt\6.8.0\msvc2022_64;C:\Qt\6.7.3\msvc2022_64;C:\Qt\6.7.2\msvc2022_64;C:\Qt\6.7.1\msvc2022_64;C:\Qt\6.7.0\msvc2022_64;C:\Qt\6.6.3\msvc2022_64;C:\Qt\6.6.2\msvc2022_64;C:\Qt\6.6.1\msvc2022_64;C:\Qt\6.6.0\msvc2022_64;C:\Qt\6.5.3\msvc2022_64;C:\Qt\6.5.2\msvc2022_64;C:\Qt\6.5.1\msvc2022_64;C:\Qt\6.5.0\msvc2022_64"

echo INFO: Searching for Qt installation...

:: 检查当前PATH中是否已有Qt
where qmake >nul 2>&1
if !errorlevel! equ 0 (
    for /f "tokens=*" %%i in ('qmake -query QT_VERSION') do set CURRENT_QT_VERSION=%%i
    for /f "tokens=*" %%i in ('qmake -query QT_INSTALL_PREFIX') do set CURRENT_QT_PATH=%%i
    echo SUCCESS: Qt !CURRENT_QT_VERSION! already found in PATH
    echo Path: !CURRENT_QT_PATH!
    goto :found_qt
)

:: 搜索Qt安装
set "FOUND_QT="
for %%p in (%QT_PATHS%) do (
    if exist "%%p\bin\qmake.exe" (
        set "FOUND_QT=%%p"
        echo INFO: Found Qt at: %%p
        goto :setup_qt
    )
)

:: 如果没找到，提示用户
if not defined FOUND_QT (
    echo ERROR: Qt not found in common installation paths.
    echo.
    echo Please install Qt from: https://www.qt.io/download
    echo Or manually add Qt to your PATH:
    echo   set PATH=C:\Qt\6.x.x\msvc2022_64\bin;%%PATH%%
    echo.
    pause
    exit /b 1
)

:setup_qt
echo INFO: Setting up Qt environment...
set "PATH=%FOUND_QT%\bin;%PATH%"

:: 验证Qt设置
where qmake >nul 2>&1
if !errorlevel! neq 0 (
    echo ERROR: Failed to setup Qt environment
    pause
    exit /b 1
)

for /f "tokens=*" %%i in ('qmake -query QT_VERSION') do set QT_VERSION=%%i
echo SUCCESS: Qt %QT_VERSION% is now available

:found_qt
echo.
echo Qt Environment Ready!
echo You can now run build_windows.bat to compile the project.
echo.
pause