#ifndef WINDOWSVIEW_H
#define WINDOWSVIEW_H

#include "../../mvc/BaseView.h"
#include <QResizeEvent>

#ifdef Q_OS_WIN

class WindowsWebViewBridge;

/**
 * @brief Windows平台的View实现
 * 使用WindowsWebViewBridge来显示WebView2内容
 */
class WindowsView : public BaseView
{
    Q_OBJECT

public:
    explicit WindowsView(QWidget *parent = nullptr);
    ~WindowsView() override;

    // 实现基类的纯虚函数
    WebViewBridge* getWebViewBridge() override;
    void initializeView() override;
    void loadHtml(const QString& html) override;
    void loadUrl(const QString& url) override;
    void showView() override;

protected:
    // 重写窗口大小调整事件
    void resizeEvent(QResizeEvent* event) override;

private:
    void setupLayout();

private:
    WindowsWebViewBridge* m_webViewBridge;
};

#endif // Q_OS_WIN

#endif // WINDOWSVIEW_H