#include "WindowsView.h"
#include "WindowsWebViewBridge.h"
#include <QVBoxLayout>
#include <QDebug>

#ifdef Q_OS_WIN

WindowsView::WindowsView(QWidget *parent)
    : BaseView(parent)
    , m_webViewBridge(nullptr)
{
    qDebug() << "WindowsView::WindowsView() - Constructor called";
    setupLayout();
    qDebug() << "WindowsView::WindowsView() - Constructor completed";
}

WindowsView::~WindowsView()
{
    if (m_webViewBridge) {
        delete m_webViewBridge;
        m_webViewBridge = nullptr;
    }
}

WebViewBridge* WindowsView::getWebViewBridge()
{
    return m_webViewBridge;
}

void WindowsView::initializeView()
{
    qDebug() << "WindowsView::initializeView() - Starting initialization";
    
    if (!m_webViewBridge) {
        qDebug() << "WindowsView::initializeView() - Creating WindowsWebViewBridge";
        m_webViewBridge = new WindowsWebViewBridge(this);
        qDebug() << "WindowsView::initializeView() - WindowsWebViewBridge created";
        
        // 连接信号
        qDebug() << "WindowsView::initializeView() - Connecting signals";
        connect(m_webViewBridge, &WebViewBridge::webViewReady, 
                this, &BaseView::viewReady);
        qDebug() << "WindowsView::initializeView() - Signals connected";
        
        // 初始化WebView
        qDebug() << "WindowsView::initializeView() - Initializing WebView";
        m_webViewBridge->initializeWebView();
        qDebug() << "WindowsView::initializeView() - WebView initialization called";
    } else {
        qDebug() << "WindowsView::initializeView() - WebViewBridge already exists";
    }
    
    qDebug() << "WindowsView::initializeView() - Initialization completed";
}

void WindowsView::loadHtml(const QString& html)
{
    qDebug() << "WindowsView::loadHtml() - Loading HTML content, length:" << html.length();
    
    if (m_webViewBridge) {
        m_webViewBridge->loadHtml(html);
        qDebug() << "WindowsView::loadHtml() - HTML loading delegated to WebViewBridge";
    } else {
        qWarning() << "WindowsView::loadHtml() - WebViewBridge is null!";
    }
}

void WindowsView::loadUrl(const QString& url)
{
    qDebug() << "WindowsView::loadUrl() - Loading URL:" << url;
    
    if (m_webViewBridge) {
        m_webViewBridge->loadUrl(url);
        qDebug() << "WindowsView::loadUrl() - URL loading delegated to WebViewBridge";
    } else {
        qWarning() << "WindowsView::loadUrl() - WebViewBridge is null!";
    }
}

void WindowsView::showView()
{
    qDebug() << "WindowsView::showView() - Showing window";
    qDebug() << "WindowsView::showView() - Current size:" << size();
    qDebug() << "WindowsView::showView() - Current position:" << pos();
    qDebug() << "WindowsView::showView() - Is visible before show():" << isVisible();
    
    show();
    raise();
    activateWindow();
    
    qDebug() << "WindowsView::showView() - Is visible after show():" << isVisible();
    qDebug() << "WindowsView::showView() - Final geometry:" << geometry();
}

void WindowsView::resizeEvent(QResizeEvent* event)
{
    QWidget::resizeEvent(event);
    
    // 通知WebViewBridge调整WebView2控件大小
    if (m_webViewBridge) {
        m_webViewBridge->resizeWebView();
    }
}

void WindowsView::setupLayout()
{
    qDebug() << "WindowsView::setupLayout() - Setting up layout";
    
    // 创建主布局
    QVBoxLayout* layout = new QVBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->setSpacing(0);
    
    setLayout(layout);
    qDebug() << "WindowsView::setupLayout() - Layout created and set";
    
    // 设置窗口属性
    setMinimumSize(800, 600);
    setWindowTitle("GGTPassword - Windows WebView2");
    
    qDebug() << "WindowsView::setupLayout() - Window properties set";
    qDebug() << "WindowsView::setupLayout() - Minimum size:" << minimumSize();
    qDebug() << "WindowsView::setupLayout() - Window title:" << windowTitle();
}

#endif // Q_OS_WIN