#ifndef MACOSVIEW_H
#define MACOSVIEW_H

#include "../../mvc/BaseView.h"
#include <QKeyEvent>

#ifdef Q_OS_MACOS

class MacOSWebViewBridge;
class MacOSMenu;

/**
 * @brief macOS平台的View实现
 * 使用MacOSWebViewBridge来显示WebView内容，并集成原生macOS菜单
 */
class MacOSView : public BaseView
{
    Q_OBJECT

public:
    explicit MacOSView(QWidget *parent = nullptr);
    ~MacOSView() override;

    // 实现基类的纯虚函数
    WebViewBridge* getWebViewBridge() override;
    void initializeView() override;
    void loadHtml(const QString& html) override;
    void loadUrl(const QString& url) override;
    void showView() override;

protected:
    // 重写键盘事件处理函数
    void keyPressEvent(QKeyEvent* event) override;
    void keyReleaseEvent(QKeyEvent* event) override;
    bool eventFilter(QObject* obj, QEvent* event) override;

private:
    void setupLayout();
    void setupMenu();
    void setupKeyboardEventHandling();
    
    /**
     * @brief 处理快捷键组合
     * @param key 按键
     * @param modifiers 修饰键
     * @return 如果处理了快捷键返回true，否则返回false
     */
    bool handleShortcut(int key, Qt::KeyboardModifiers modifiers);

private:
    MacOSWebViewBridge* m_webViewBridge;
    MacOSMenu* m_menu;
};

#endif // Q_OS_MACOS

#endif // MACOSVIEW_H