#ifdef Q_OS_IOS

#import "IOSViewController.h"
#import <WebKit/WebKit.h>

@implementation IOSViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor blueColor]; // 临时设为蓝色以便调试
    NSLog(@"IOSViewController: viewDidLoad called, view frame: %@", NSStringFromCGRect(self.view.frame));
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    NSLog(@"IOSViewController: viewWillAppear, view frame: %@", NSStringFromCGRect(self.view.frame));
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    NSLog(@"IOSViewController: viewDidAppear, view frame: %@", NSStringFromCGRect(self.view.frame));
    if (self.webView) {
        NSLog(@"IOSViewController: WebView frame: %@", NSStringFromCGRect(self.webView.frame));
    }
}

- (void)setupWebView:(WKWebView*)webView {
    NSLog(@"IOSViewController: setupWebView called");
    
    if (!webView) {
        NSLog(@"IOSViewController: WebView is nil!");
        return;
    }
    
    self.webView = webView;
    NSLog(@"IOSViewController: WebView assigned, frame: %@", NSStringFromCGRect(webView.frame));
    
    // 移除WebView的现有父视图
    [self.webView removeFromSuperview];
    
    // 添加到当前视图控制器
    [self.view addSubview:self.webView];
    NSLog(@"IOSViewController: WebView added to view");
    
    // 设置约束
    self.webView.translatesAutoresizingMaskIntoConstraints = NO;
    [NSLayoutConstraint activateConstraints:@[
        [self.webView.topAnchor constraintEqualToAnchor:self.view.safeAreaLayoutGuide.topAnchor],
        [self.webView.leadingAnchor constraintEqualToAnchor:self.view.leadingAnchor],
        [self.webView.trailingAnchor constraintEqualToAnchor:self.view.trailingAnchor],
        [self.webView.bottomAnchor constraintEqualToAnchor:self.view.safeAreaLayoutGuide.bottomAnchor]
    ]];
    NSLog(@"IOSViewController: WebView constraints activated");
}

- (UIStatusBarStyle)preferredStatusBarStyle {
    return UIStatusBarStyleDefault;
}

- (BOOL)prefersStatusBarHidden {
    return NO;
}

@end

#endif // Q_OS_IOS