#ifndef IOSVIEW_H
#define IOSVIEW_H

#include "../../mvc/BaseView.h"

#ifdef Q_OS_IOS

class IOSWebViewBridge;

/**
 * @brief iOS平台的View实现
 * 使用IOSWebViewBridge来显示WebView内容
 */
class IOSView : public BaseView
{
    Q_OBJECT

public:
    explicit IOSView(QObject *parent = nullptr);
    ~IOSView() override;

    // 实现基类的纯虚函数
    WebViewBridge* getWebViewBridge() override;
    void initializeView() override;
    void loadHtml(const QString& html) override;
    void loadUrl(const QString& url) override;
    void showView() override;

private:
    void setupLayout();

private:
    IOSWebViewBridge* m_webViewBridge;
};

#endif // Q_OS_IOS

#endif // IOSVIEW_H