#include "IOSView.h"

#ifdef Q_OS_IOS

#include "IOSWebViewBridge.h"
#include <QDebug>

IOSView::IOSView(QObject *parent)
    : BaseView(parent)
    , m_webViewBridge(nullptr)
{
    m_webViewBridge = new IOSWebViewBridge(this);
    
    // 连接WebView准备就绪信号
    connect(m_webViewBridge, &WebViewBridge::webViewReady,
            this, &BaseView::viewReady);
}

IOSView::~IOSView()
{
    // m_webViewBridge会被Qt的父子关系自动删除
}

WebViewBridge* IOSView::getWebViewBridge()
{
    return m_webViewBridge;
}

void IOSView::initializeView()
{
    if (m_webViewBridge) {
        m_webViewBridge->initializeWebView();
    }
}

void IOSView::loadHtml(const QString& html)
{
    if (m_webViewBridge) {
        m_webViewBridge->loadHtml(html);
    }
}

void IOSView::loadUrl(const QString& url)
{
    if (m_webViewBridge) {
        m_webViewBridge->loadUrl(url);
    }
}

void IOSView::showView()
{
    // 获取WebView并显示
    if (m_webViewBridge) {
        IOSWebViewBridge* iosBridge = static_cast<IOSWebViewBridge*>(m_webViewBridge);
        iosBridge->showWebView();
    }
    qDebug() << "IOSView::showView() - Native WKWebView displayed";
}

void IOSView::setupLayout()
{
    // iOS平台使用QML，不需要QWidget布局
    // 此方法保留为空实现以保持接口兼容性
}

#endif // Q_OS_IOS