package com.ggt.ggtpassword;

import android.util.Log;
import android.webkit.JavascriptInterface;

/**
 * AndroidInterface for WebView JavaScript bridge.
 * Exposes method "postMessage" callable from JS to forward messages to native (C++ via JNI).
 */
public class QtBridgeInterface {
    private static final String TAG = "GGTWebView";

    static {
        Log.d(TAG, "QtBridgeInterface: loaded");
    }

    @JavascriptInterface
    public void postMessage(String message) {
        Log.d(TAG, "QtBridgeInterface.postMessage: " + message);
        onMessage(message);
    }

    // Forward to C++ via JNI (defined in AndroidWebViewBridge.cpp)
    private static native void onMessage(String message);
}