package com.ggt.ggtpassword;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.util.Log;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;

public class LoggingWebViewClient extends WebViewClient {
    private static final String TAG = "GGTWebView";

    public LoggingWebViewClient() {
        Log.d(TAG, "LoggingWebViewClient: constructed");
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        Log.d(TAG, "onPageStarted: url=" + url);
        super.onPageStarted(view, url, favicon);
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        Log.d(TAG, "onPageFinished: url=" + url);
        try {
            String bridgeScript = "(function(){ if(window.__QtBridgeInjected){return;} window.__QtBridgeInjected = true; var QtBridge={ sendMessage:function(method, params){ var msg={method:method, params:params||{}}; if(window.AndroidInterface && typeof window.AndroidInterface.postMessage==='function'){ try{ window.AndroidInterface.postMessage(JSON.stringify(msg)); }catch(e){ console.log('[Android] postMessage error:', e); } } else { console.log('[Android] AndroidInterface missing, message:', msg); } }, postMessage:function(message){ if(window.AndroidInterface && typeof window.AndroidInterface.postMessage==='function'){ try{ window.AndroidInterface.postMessage(message); }catch(e){ console.log('[Android] postMessage error:', e); } } else { console.log('[Android] AndroidInterface missing, raw:', message); } }, onMessage:function(callback){ if(typeof callback==='function'){ window.nativeMessageCallback=callback; console.log('[Android] onMessage callback registered'); } else { console.log('[Android] onMessage requires a function'); } }, handleMessage:function(message){ try{ var data=(typeof message==='string')?JSON.parse(message):message; if(window.nativeMessageCallback && typeof window.nativeMessageCallback==='function'){ window.nativeMessageCallback(data); } else { console.log('[Android] nativeMessageCallback not set:', data); } } catch(e){ console.log('[Android] handleMessage JSON parse error:', e, message); } } }; window.QtBridge=QtBridge; window.NativeBridge=QtBridge; console.log('[Android] QtBridge injected (onPageFinished)'); })();";
            view.evaluateJavascript(bridgeScript, null);
            view.evaluateJavascript("if (window.QtBridge && window.QtBridge.handleMessage) { window.QtBridge.handleMessage({method:'bridgeReady', params:{url: document.location.href}}); }", null);
            // 额外触发一次 JS -> Native 验证消息
            view.evaluateJavascript("if (window.QtBridge && window.QtBridge.sendMessage) { window.QtBridge.sendMessage('jsPing', { source: 'onPageFinished', ts: Date.now() }); }", null);
            Log.d(TAG, "onPageFinished: bridge script injected");
        } catch (Exception e) {
            Log.e(TAG, "onPageFinished: bridge injection failed", e);
        }
        super.onPageFinished(view, url);
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        String url = request != null ? String.valueOf(request.getUrl()) : "<null>";
        Log.d(TAG, "shouldOverrideUrlLoading: requestUrl=" + url);
        return false; // Let WebView handle it
    }

    @Override
    public void onLoadResource(WebView view, String url) {
        Log.d(TAG, "onLoadResource: " + url);
        super.onLoadResource(view, url);
    }

    @Override
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        String reqUrl = request != null ? String.valueOf(request.getUrl()) : "<null>";
        CharSequence desc = error != null ? error.getDescription() : "<null>";
        int code = (error != null && Build.VERSION.SDK_INT >= 23) ? error.getErrorCode() : -1;
        Log.e(TAG, "onReceivedError: code=" + code + ", desc=" + desc + ", url=" + reqUrl);
        super.onReceivedError(view, request, error);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        Log.e(TAG, "onReceivedError(deprecated): code=" + errorCode + ", desc=" + description + ", url=" + failingUrl);
        super.onReceivedError(view, errorCode, description, failingUrl);
    }

    @Override
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        Log.e(TAG, "onReceivedSslError: error=" + (error != null ? error.toString() : "<null>") );
        // Default behavior: cancel or proceed based on policy; here proceed for diagnostics only
        handler.proceed();
    }

    @Override
    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        String reqUrl = request != null ? String.valueOf(request.getUrl()) : "<null>";
        int status = errorResponse != null ? errorResponse.getStatusCode() : -1;
        Log.e(TAG, "onReceivedHttpError: status=" + status + ", url=" + reqUrl);
        super.onReceivedHttpError(view, request, errorResponse);
    }

    @Override
    public void onPageCommitVisible(WebView view, String url) {
        Log.d(TAG, "onPageCommitVisible: url=" + url);
        super.onPageCommitVisible(view, url);
    }

    @Override
    public boolean onRenderProcessGone(WebView view, android.webkit.RenderProcessGoneDetail detail) {
        Log.e(TAG, "onRenderProcessGone: didCrash=" + (detail != null && detail.didCrash()));
        return super.onRenderProcessGone(view, detail);
    }

    @SuppressWarnings("deprecation")
    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Log.d(TAG, "shouldOverrideUrlLoading(deprecated): url=" + url);
        return false; // Let WebView handle it
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        Log.d(TAG, "shouldInterceptRequest(deprecated): " + url);
        return super.shouldInterceptRequest(view, url);
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        String reqUrl = request != null ? String.valueOf(request.getUrl()) : "<null>";
        Log.d(TAG, "shouldInterceptRequest: " + reqUrl);
        return super.shouldInterceptRequest(view, request);
    }
}