package com.ggt.ggtpassword;

import android.util.Log;
import android.webkit.ConsoleMessage;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

public class LoggingWebChromeClient extends WebChromeClient {
    private static final String TAG = "GGTWebView";

    public LoggingWebChromeClient() {
        Log.d(TAG, "LoggingWebChromeClient: constructed");
    }

    @Override
    public boolean onConsoleMessage(ConsoleMessage message) {
        if (message != null) {
            Log.d(TAG, "console: " + message.message() +
                    " (" + message.sourceId() + ":" + message.lineNumber() + ")" );
        } else {
            Log.d(TAG, "console: <null message>");
        }
        return true; // handled
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        Log.d(TAG, "progress: " + newProgress + "%");
        super.onProgressChanged(view, newProgress);
    }

    @Override
    public void onReceivedTitle(WebView view, String title) {
        Log.d(TAG, "title: " + title);
        super.onReceivedTitle(view, title);
    }

    @Override
    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        Log.d(TAG, "jsAlert: url=" + url + ", message=" + message);
        return super.onJsAlert(view, url, message, result);
    }

    @Override
    public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
        Log.d(TAG, "jsConfirm: url=" + url + ", message=" + message);
        return super.onJsConfirm(view, url, message, result);
    }

    @Override
    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        Log.d(TAG, "jsPrompt: url=" + url + ", message=" + message + ", default=" + defaultValue);
        return super.onJsPrompt(view, url, message, defaultValue, result);
    }

    @Override
    public void onPermissionRequest(android.webkit.PermissionRequest request) {
        String[] resources = request != null ? request.getResources() : null;
        Log.d(TAG, "permissionRequest: resources=" + (resources != null ? java.util.Arrays.toString(resources) : "<null>"));
        super.onPermissionRequest(request);
    }

    @Override
    public void onGeolocationPermissionsShowPrompt(String origin, android.webkit.GeolocationPermissions.Callback callback) {
        Log.d(TAG, "geolocationPrompt: origin=" + origin);
        super.onGeolocationPermissionsShowPrompt(origin, callback);
    }

    @Override
    public boolean onShowFileChooser(WebView webView, android.webkit.ValueCallback<android.net.Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        String[] accept = (fileChooserParams != null ? fileChooserParams.getAcceptTypes() : new String[]{});
        Log.d(TAG, "showFileChooser: acceptTypes=" + java.util.Arrays.toString(accept));
        return super.onShowFileChooser(webView, filePathCallback, fileChooserParams);
    }

    @Override
    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, android.os.Message resultMsg) {
        Log.d(TAG, "onCreateWindow: isDialog=" + isDialog + ", userGesture=" + isUserGesture);
        return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
    }
}