# Android 平台支持

本文档介绍如何在Android平台上编译和运行GGTPassword应用程序。

## 概述

Android平台实现使用原生Android WebView组件，通过JNI（Java Native Interface）与Qt C++代码进行通信。主要特性包括：

- 🌐 **原生WebView**：使用Android系统内置的WebView组件
- 🔗 **JNI桥接**：通过JNI实现JavaScript与C++的双向通信
- 📱 **移动优化**：支持触摸操作、屏幕旋转、全屏模式
- 🔧 **权限管理**：集成Android权限系统
- 🎯 **生命周期**：完整的Android应用生命周期支持

## 架构设计

### 核心组件

```
platform/android/
├── AndroidWebViewBridge.h/cpp    # WebView桥接实现
├── AndroidView.h/cpp              # Android视图管理
└── README.md                      # 本文档
```

### 类关系图

```
BaseView (Qt)
    ↓
AndroidView
    ↓
AndroidWebViewBridge
    ↓
JNI → Android WebView (Java)
```

## 开发环境要求

### 必需软件

1. **Qt 6.2+** 或 **Qt 5.15+**
   - 必须包含Android支持
   - 需要QtAndroidExtras模块

2. **Android SDK**
   - API Level 24+ (Android 7.0+)
   - 推荐使用最新版本

3. **Android NDK**
   - NDK r21+
   - 推荐使用最新LTS版本

4. **Java JDK**
   - JDK 8 或 JDK 11
   - 用于Android应用打包

5. **CMake 3.16+**
   - 用于构建系统

### 可选工具

- **Android Studio**：用于调试和APK分析
- **Ninja**：更快的构建系统

## 环境配置

### 1. 设置环境变量

```bash
# Android SDK路径
export ANDROID_SDK_ROOT=/path/to/android-sdk
# 或者使用旧的环境变量名
export ANDROID_HOME=/path/to/android-sdk

# Android NDK路径
export ANDROID_NDK_ROOT=/path/to/android-ndk

# Qt for Android路径
export QT_ANDROID_ROOT=/path/to/Qt/6.x.x/android_arm64_v8a

# Java JDK路径
export JAVA_HOME=/path/to/jdk
```

### 2. Windows环境变量设置

```cmd
set ANDROID_SDK_ROOT=C:\Android\Sdk
set ANDROID_NDK_ROOT=C:\Android\Sdk\ndk\25.x.x
set QT_ANDROID_ROOT=C:\Qt\6.x.x\android_arm64_v8a
set JAVA_HOME=C:\Program Files\Java\jdk-11.x.x
```

## 编译步骤

### 使用编译脚本（推荐）

#### Linux/macOS

```bash
# 使用默认配置编译
./build_android.sh

# 编译Debug版本
./build_android.sh -t Debug

# 编译32位ARM版本
./build_android.sh -a armeabi-v7a

# 只编译不生成APK
./build_android.sh --no-apk

# 清理构建文件
./build_android.sh --clean

# 查看帮助
./build_android.sh --help
```

#### Windows

```cmd
REM 使用默认配置编译
build_android.bat

REM 编译Debug版本
build_android.bat -t Debug

REM 编译32位ARM版本
build_android.bat -a armeabi-v7a

REM 只编译不生成APK
build_android.bat --no-apk

REM 清理构建文件
build_android.bat --clean

REM 查看帮助
build_android.bat --help
```

### 手动编译

```bash
# 1. 创建构建目录
mkdir build-android-arm64-v8a
cd build-android-arm64-v8a

# 2. 配置CMake
cmake \
    -DCMAKE_BUILD_TYPE=Release \
    -DCMAKE_TOOLCHAIN_FILE=$ANDROID_NDK_ROOT/build/cmake/android.toolchain.cmake \
    -DANDROID_ABI=arm64-v8a \
    -DANDROID_PLATFORM=android-24 \
    -DANDROID_STL=c++_shared \
    -DCMAKE_PREFIX_PATH=$QT_ANDROID_ROOT \
    -DQT_ANDROID_ROOT=$QT_ANDROID_ROOT \
    -DANDROID_SDK_ROOT=$ANDROID_SDK_ROOT \
    -DANDROID_NDK_ROOT=$ANDROID_NDK_ROOT \
    ..

# 3. 编译
make -j$(nproc)

# 4. 生成APK（可选）
$QT_ANDROID_ROOT/bin/androiddeployqt \
    --input android-GGTPassword-deployment-settings.json \
    --output ../android \
    --android-platform android-24 \
    --jdk $JAVA_HOME \
    --gradle
```

## 支持的Android ABI

| ABI | 描述 | 推荐使用 |
|-----|------|----------|
| `arm64-v8a` | 64位ARM（现代设备） | ✅ 推荐 |
| `armeabi-v7a` | 32位ARM（兼容性） | ⚠️ 兼容性 |
| `x86_64` | 64位x86（模拟器） | 🔧 调试用 |
| `x86` | 32位x86（旧模拟器） | ❌ 不推荐 |

## 调试和测试

### 1. 使用Android模拟器

```bash
# 启动模拟器
$ANDROID_SDK_ROOT/emulator/emulator -avd <AVD_NAME>

# 安装APK
$ANDROID_SDK_ROOT/platform-tools/adb install android/build/outputs/apk/debug/android-debug.apk
```

### 2. 使用真机调试

```bash
# 启用USB调试后连接设备
$ANDROID_SDK_ROOT/platform-tools/adb devices

# 安装APK
$ANDROID_SDK_ROOT/platform-tools/adb install android/build/outputs/apk/debug/android-debug.apk
```

### 3. WebView调试

在Chrome浏览器中访问 `chrome://inspect` 可以调试WebView内容。

### 4. 日志查看

```bash
# 查看应用日志
$ANDROID_SDK_ROOT/platform-tools/adb logcat | grep GGTPassword

# 查看Qt日志
$ANDROID_SDK_ROOT/platform-tools/adb logcat | grep "Qt"
```

## 常见问题

### 1. 编译错误

**问题**：找不到Android SDK/NDK
```
CMake Error: Could not find Android SDK/NDK
```

**解决方案**：
- 检查环境变量是否正确设置
- 确认SDK/NDK路径存在且可访问

**问题**：Qt模块找不到
```
Could not find a package configuration file provided by "Qt6AndroidExtras"
```

**解决方案**：
- 确认Qt安装包含Android支持
- 检查QT_ANDROID_ROOT路径是否正确

### 2. 运行时错误

**问题**：应用启动崩溃
```
java.lang.UnsatisfiedLinkError: dlopen failed
```

**解决方案**：
- 检查ABI是否匹配设备架构
- 确认所有依赖库都已正确打包

**问题**：WebView无法加载
```
WebView initialization failed
```

**解决方案**：
- 检查网络权限是否已添加
- 确认WebView组件在设备上可用

### 3. 权限问题

**问题**：网络访问被拒绝

**解决方案**：在AndroidManifest.xml中添加：
```xml
<uses-permission android:name="android.permission.INTERNET" />
<uses-permission android:name="android.permission.ACCESS_NETWORK_STATE" />
```

## 性能优化

### 1. 编译优化

- 使用Release构建类型
- 启用编译器优化选项
- 使用适当的Android ABI

### 2. 运行时优化

- 合理管理WebView生命周期
- 及时释放不需要的资源
- 使用异步操作避免阻塞UI

### 3. APK大小优化

- 只包含必要的ABI
- 启用代码混淆和压缩
- 移除未使用的资源

## 发布准备

### 1. 签名配置

创建发布密钥：
```bash
keytool -genkey -v -keystore release-key.keystore -alias ggtpassword -keyalg RSA -keysize 2048 -validity 10000
```

### 2. 构建发布版本

```bash
./build_android.sh -t Release
```

### 3. APK优化

使用Android Studio或命令行工具进行APK分析和优化。

## 技术支持

如果遇到问题，请：

1. 查看本文档的常见问题部分
2. 检查Qt和Android官方文档
3. 在项目仓库提交Issue

## 更新日志

- **v1.0.0**：初始Android平台支持
  - 基本WebView桥接功能
  - JNI通信机制
  - 生命周期管理
  - 权限系统集成