#ifndef BASEVIEW_H
#define BASEVIEW_H

#ifdef Q_OS_IOS
#include <QObject>
#else
#include <QWidget>
#endif
#include <QString>

class WebViewBridge;
class BaseController;

/**
 * @brief MVC架构中的View基类
 * 负责用户界面展示，通过WebView实现
 */
#ifdef Q_OS_IOS
class BaseView : public QObject
#else
class BaseView : public QWidget
#endif
{
    Q_OBJECT

public:
#ifdef Q_OS_IOS
    explicit BaseView(QObject *parent = nullptr);
#else
    explicit BaseView(QWidget *parent = nullptr);
#endif
    virtual ~BaseView() = default;

    /**
     * @brief 设置控制器
     * @param controller 控制器对象
     */
    void setController(BaseController* controller);

    /**
     * @brief 获取WebView桥接对象
     * @return WebView桥接对象指针
     */
    virtual WebViewBridge* getWebViewBridge() = 0;

    /**
     * @brief 初始化视图
     */
    virtual void initializeView() = 0;

    /**
     * @brief 加载HTML内容
     * @param html HTML内容
     */
    virtual void loadHtml(const QString& html) = 0;

    /**
     * @brief 加载URL
     * @param url 要加载的URL
     */
    virtual void loadUrl(const QString& url) = 0;

    /**
     * @brief 显示视图
     */
    virtual void showView() = 0;

protected:
    /**
     * @brief 获取控制器
     * @return 控制器对象指针
     */
    BaseController* getController() const;

signals:
    /**
     * @brief 视图准备就绪信号
     */
    void viewReady();

    /**
     * @brief 视图关闭信号
     */
    void viewClosed();

private:
    BaseController* m_controller;
};

#endif // BASEVIEW_H