#ifndef BASEMODEL_H
#define BASEMODEL_H

#include <QObject>
#include <QJsonObject>
#include <QJsonDocument>
#include <QString>

/**
 * @brief MVC架构中的Model基类
 * 负责数据管理和业务逻辑
 */
class BaseModel : public QObject
{
    Q_OBJECT

public:
    explicit BaseModel(QObject *parent = nullptr);
    virtual ~BaseModel() = default;

    /**
     * @brief 将模型数据序列化为JSON
     * @return JSON对象
     */
    virtual QJsonObject toJson() const = 0;

    /**
     * @brief 从JSON数据反序列化模型
     * @param json JSON对象
     * @return 是否成功
     */
    virtual bool fromJson(const QJsonObject& json) = 0;

    /**
     * @brief 验证模型数据的有效性
     * @return 是否有效
     */
    virtual bool isValid() const = 0;

    /**
     * @brief 重置模型到初始状态
     */
    virtual void reset() = 0;

signals:
    /**
     * @brief 模型数据发生变化时发射
     */
    void dataChanged();

    /**
     * @brief 模型状态发生变化时发射
     * @param status 新状态
     */
    void statusChanged(const QString& status);

protected:
    /**
     * @brief 通知数据已更改
     */
    void notifyDataChanged();

    /**
     * @brief 通知状态已更改
     * @param status 新状态
     */
    void notifyStatusChanged(const QString& status);
};

#endif // BASEMODEL_H