# GGTPassword 编译快速开始（多平台）

本指南集中记录各平台的编译依赖、命令与参数，涵盖 macOS、iOS、Android、Windows。所有命令均在项目根目录运行。

## 总体依赖
- 操作系统：根据目标平台选择（macOS、Windows、Linux 用于交叉构建 Android）
- `Qt 6.x`：推荐 6.9.x 或 6.10.x，对应平台包必须安装（macOS/iOS/Android/Windows）
- `CMake >= 3.16`
- 源码位置：`GGTPassword/`

建议先验证基础工具：
- `cmake --version`

---

## macOS 构建

依赖
- `macOS`（10.15+ 推荐）
- `Xcode` 或 Command Line Tools（用于编译工具链）
- `Qt for macOS`（官方安装或 Homebrew）
- `CMake`

命令
- 使用统一脚本：`./build.sh`

参数
- `-p, --platform`：`macos|windows|all`（默认 `macos`）
- `-c, --config`：`Debug|Release`（默认 `Debug`）
- `-j, --jobs`：并行编译任务数（默认自动检测）
- `--clean`：清理构建目录
- `--debug-mode`：启用调试功能（Safari 开发者工具）

示例
- 构建 Debug：`./build.sh`
- 构建 Release：`./build.sh -p macos -c Release`
- 清理：`./build.sh --clean`

说明
- 脚本自动寻找 Qt CMake 目录：优先官方安装（`~/Qt/6.x/macos/lib/cmake/Qt6`），其次 Homebrew（`/opt/homebrew/lib/cmake/Qt6`）。
- 部署目标默认 `10.15`，产物在 `build/macos/GGTPassword.app`。

---

## iOS 构建

依赖
- `macOS`
- `Xcode`（建议最新稳定版）
- `Qt for iOS`（官方安装，例如 `~/Qt/6.10.0/ios`）
- `CMake`

命令
- 使用 iOS 专用脚本：`./build_ios.sh`

参数
- `-t, --target`：`device|simulator|both`（默认 `both`）
- `-c, --config`：`Debug|Release`（默认 `Debug`）
- `-d, --team-id`：Apple 开发团队 ID（真机构建与自动签名）
- `-i, --identity`：代码签名身份（默认 `iPhone Developer`；建议使用 `Apple Development`）
- `-b, --bundle-id`：覆盖 Bundle Identifier（不提供则使用项目默认 `com.ggt.GGTPassword`）
- `-h, --help`：显示帮助

示例
- 模拟器（Debug）：`./build_ios.sh -t simulator`
- 真机（Release，自动签名）：`./build_ios.sh -t device -c Release -d YOUR_TEAM_ID -i "Apple Development"`
- 指定 Bundle ID：`./build_ios.sh -t device -b com.yourcorp.app -d YOUR_TEAM_ID`
- 同时构建两者：`./build_ios.sh -t both -c Release -d YOUR_TEAM_ID`

说明与限制
- 模拟器当前使用 `x86_64` 架构（基于 Qt 6.10.0 的限制），目标 `iphonesimulator`。
- 真机目标 `iphoneos`，默认 `arm64`。
- 自动签名：设备构建优先使用 `xcodebuild -allowProvisioningUpdates`，失败则回退到 `cmake --build`。
- 验证签名身份：`security find-identity -v -p codesigning`。
- Bundle ID 已参数化，Info.plist 读取 `$(PRODUCT_BUNDLE_IDENTIFIER)`，与 CMake/Xcode 设置保持一致。

产物位置
- 设备：`build-ios-device/Release-iphoneos/GGTPassword.app`
- 模拟器：`build-ios-simulator/Debug-iphonesimulator/GGTPassword.app`

---

## Android 构建

依赖
- `Android SDK`：环境变量 `ANDROID_SDK_ROOT` 或 `ANDROID_HOME`
- `Android NDK`：环境变量 `ANDROID_NDK_ROOT`（脚本可自动从 SDK 下探测最新版本）
- `Qt for Android`：环境变量 `QT_ANDROID_ROOT`（例如 `~/Qt/6.10.0/android_arm64_v8a`）
- `Java JDK`：环境变量 `JAVA_HOME`
- `CMake`（必需）与 `Ninja`（可选）

命令
- 使用 Android 专用脚本：`./build_android.sh`

参数
- `-t, --type`：`Debug|Release`（默认 `Release`）
- `-a, --abi`：`arm64-v8a|armeabi-v7a|x86|x86_64`（默认 `arm64-v8a`）
- `-p, --platform`：NDK/CMake 平台（默认 `android-33`，脚本会限制到不超过 `android-35`）
- `-d, --dir`：构建目录（默认 `build-android-<ABI>`）
- `--no-apk`：只编译，不打包 APK
- `-c, --clean`：清理构建文件
- `-h, --help`：显示帮助

示例
- 默认 Release：`./build_android.sh`
- Debug + 32 位 ARM：`./build_android.sh -t Debug -a armeabi-v7a`
- 指定 NDK 平台：`./build_android.sh -p android-33`
- 清理：`./build_android.sh --clean`

说明
- 生成器：自动检测 `ninja`；否则使用 `Unix Makefiles`。
- 脚本为 Gradle/`androiddeployqt` 生成 Android 项目并查找 APK 输出，Manifest 默认包名 `com.ggt.ggtpassword`（可后续按需要修改）。
- 资源加载：原生 WebView 会从 `android_asset/web/` 加载初始页面（见 `AndroidView.cpp`）。

产物位置
- 构建目录：`build-android-<ABI>/`
- APK 示例输出：`build-android-<ABI>/android-build/build/outputs/apk/.../*.apk`

---

## Windows 构建

依赖
- `Windows 10/11`
- `Visual Studio 2022`（工作负载：使用 C++ 的桌面开发；MSVC v143、Windows SDK）
- `Qt for Windows`（MSVC 2022 64-bit 套件）
- `CMake`
- WebView2 运行时（通常 Win11 自带；Win10 需安装）

命令
- 用统一脚本：`build_windows.bat`（包装器）或 `build.bat`

参数（`build.bat`）
- 位置参数1：`app|test`（默认 `app`）
- 位置参数2：`Debug|Release`（默认 `Debug`）
- `--clean`：清理构建目录
- `--run`：构建完成后运行可执行文件
- `--deploy`：拷贝 Qt/依赖 DLL 到输出目录
- `--no-prompt`：构建结束不询问是否运行

示例
- 快速构建：`build_windows.bat`（等价于 `build.bat app Debug --clean`）
- 构建并运行：`build.bat app Release --clean --run`
- 构建测试程序：`build.bat test Debug --clean --run`

产物位置
- 主程序：`build_windows/Debug/GGTPassword.exe` 或 `build_windows/Release/GGTPassword.exe`
- 测试程序：`build_test/Debug/test_webview_simple.exe`

说明
- 需将 Qt `bin` 加入 `PATH`（例如：`set PATH=C:\Qt\6.10.0\msvc2022_64\bin;%PATH%`）。
- 可选运行 `deploy_qt_dlls.bat` 完成 DLL 部署与 WebView2Loader.dll 拷贝。

---

## 常见验证与故障排除

通用
- 详细编译输出：`cmake --build . --config Debug --verbose`
- 重新生成：删除 `build*` 目录后重新运行脚本或加 `--clean`

iOS
- 列出设备：`xcrun xctrace list devices`
- 打开 Xcode 项目：`open build-ios-device/GGTPassword.xcodeproj`

Android
- 设备连接：`adb devices`
- 查看日志：`adb logcat | grep GGTPassword`

Windows
- 检查工具：`cmake --version`、`where msbuild`

---

## 参考
- `README_iOS.md`、`ANDROID_BUILD_GUIDE.md`
- 构建脚本：`build.sh`、`build_ios.sh`、`build_android.sh`、`build.bat`、`build_windows.bat`
- 环境与问题汇总：`README_BUILD.md`、`SETUP_ENVIRONMENT.md`、`COMPILATION_STATUS.md`