@echo off
echo ========================================
echo Qt DLL Auto Deploy Script
echo ========================================

:: Set Qt path
set QT_DIR=D:\Qt\6.10.0\msvc2022_64
set BUILD_DIR=.\build_windows\Debug

:: Check Qt installation
if not exist "%QT_DIR%\bin\Qt6Cored.dll" (
    echo ERROR: Qt installation not found at %QT_DIR%
    echo Please check your Qt installation path
    pause
    exit /b 1
)

:: Check build directory
if not exist "%BUILD_DIR%\GGTPassword.exe" (
    echo ERROR: Application not found at %BUILD_DIR%\GGTPassword.exe
    echo Please build the application first
    pause
    exit /b 1
)

echo Copying Qt DLL files...

:: Copy core Qt DLL files (Debug version)
echo - Copying Qt6Cored.dll...
copy "%QT_DIR%\bin\Qt6Cored.dll" "%BUILD_DIR%\" >nul
if errorlevel 1 (
    echo ERROR: Failed to copy Qt6Cored.dll
    pause
    exit /b 1
)

echo - Copying Qt6Guid.dll...
copy "%QT_DIR%\bin\Qt6Guid.dll" "%BUILD_DIR%\" >nul
if errorlevel 1 (
    echo ERROR: Failed to copy Qt6Guid.dll
    pause
    exit /b 1
)

echo - Copying Qt6Widgetsd.dll...
copy "%QT_DIR%\bin\Qt6Widgetsd.dll" "%BUILD_DIR%\" >nul
if errorlevel 1 (
    echo ERROR: Failed to copy Qt6Widgetsd.dll
    pause
    exit /b 1
)

:: Create platforms directory
if not exist "%BUILD_DIR%\platforms" (
    echo - Creating platforms directory...
    mkdir "%BUILD_DIR%\platforms"
)

:: Copy platform plugin
echo - Copying platform plugin qwindowsd.dll...
copy "%QT_DIR%\plugins\platforms\qwindowsd.dll" "%BUILD_DIR%\platforms\" >nul
if errorlevel 1 (
    echo ERROR: Failed to copy qwindowsd.dll
    pause
    exit /b 1
)

:: Check for additional dependencies
echo Checking for additional dependencies...

:: Copy WebView2Loader.dll
echo - Copying WebView2Loader.dll...
if exist ".\third_party\webview2\runtimes\win-x64\native\WebView2Loader.dll" (
    copy ".\third_party\webview2\runtimes\win-x64\native\WebView2Loader.dll" "%BUILD_DIR%\" >nul
    if errorlevel 1 (
        echo ERROR: Failed to copy WebView2Loader.dll
        pause
        exit /b 1
    )
    echo - WebView2Loader.dll copied successfully
) else (
    echo - WebView2Loader.dll not found in third_party directory
)

:: Verify deployment
echo ========================================
echo Verifying deployment...
echo ========================================

if exist "%BUILD_DIR%\Qt6Cored.dll" (
    echo [OK] Qt6Cored.dll deployed
) else (
    echo [FAIL] Qt6Cored.dll missing
)

if exist "%BUILD_DIR%\Qt6Guid.dll" (
    echo [OK] Qt6Guid.dll deployed
) else (
    echo [FAIL] Qt6Guid.dll missing
)

if exist "%BUILD_DIR%\Qt6Widgetsd.dll" (
    echo [OK] Qt6Widgetsd.dll deployed
) else (
    echo [FAIL] Qt6Widgetsd.dll missing
)

if exist "%BUILD_DIR%\platforms\qwindowsd.dll" (
    echo [OK] qwindowsd.dll deployed
) else (
    echo [FAIL] qwindowsd.dll missing
)

if exist "%BUILD_DIR%\WebView2Loader.dll" (
    echo [OK] WebView2Loader.dll deployed
) else (
    echo [FAIL] WebView2Loader.dll missing
)

echo ========================================
echo Qt DLL deployment completed successfully!
echo ========================================
echo.
echo You can now run the application:
echo %BUILD_DIR%\GGTPassword.exe
echo.
echo Press any key to test the application...
pause >nul

:: Test run application
echo Testing application...
cd /d "%~dp0"
start "" "%BUILD_DIR%\GGTPassword.exe"

echo Application started. Check if it runs without DLL errors.
pause