#ifndef DEMOMODEL_H
#define DEMOMODEL_H

#include "../mvc/BaseModel.h"
#include <QString>
#include <QJsonObject>

/**
 * @brief 演示用的Model类
 * 展示如何继承BaseModel实现具体的数据模型
 */
class DemoModel : public BaseModel
{
    Q_OBJECT

public:
    explicit DemoModel(QObject *parent = nullptr);

    // 实现基类的纯虚函数
    QJsonObject toJson() const override;
    bool fromJson(const QJsonObject& json) override;
    bool isValid() const override;
    void reset() override;

    // 业务方法
    QString getName() const;
    void setName(const QString& name);

    int getValue() const;
    void setValue(int value);

    QString getStatus() const;
    void setStatus(const QString& status);

private:
    QString m_name;
    int m_value;
    QString m_status;
};

#endif // DEMOMODEL_H