#include "DemoModel.h"

DemoModel::DemoModel(QObject *parent)
    : BaseModel(parent)
    , m_name("Demo")
    , m_value(0)
    , m_status("ready")
{
}

QJsonObject DemoModel::toJson() const
{
    QJsonObject json;
    json["name"] = m_name;
    json["value"] = m_value;
    json["status"] = m_status;
    return json;
}

bool DemoModel::fromJson(const QJsonObject& json)
{
    if (json.contains("name") && json["name"].isString()) {
        m_name = json["name"].toString();
    }
    
    if (json.contains("value") && json["value"].isDouble()) {
        m_value = json["value"].toInt();
    }
    
    if (json.contains("status") && json["status"].isString()) {
        m_status = json["status"].toString();
    }
    
    notifyDataChanged();
    return true;
}

bool DemoModel::isValid() const
{
    return !m_name.isEmpty() && m_value >= 0;
}

void DemoModel::reset()
{
    m_name = "Demo";
    m_value = 0;
    m_status = "ready";
    notifyDataChanged();
}

QString DemoModel::getName() const
{
    return m_name;
}

void DemoModel::setName(const QString& name)
{
    if (m_name != name) {
        m_name = name;
        notifyDataChanged();
    }
}

int DemoModel::getValue() const
{
    return m_value;
}

void DemoModel::setValue(int value)
{
    if (m_value != value) {
        m_value = value;
        notifyDataChanged();
    }
}

QString DemoModel::getStatus() const
{
    return m_status;
}

void DemoModel::setStatus(const QString& status)
{
    if (m_status != status) {
        m_status = status;
        notifyStatusChanged(status);
    }
}