#ifndef DEMOCONTROLLER_H
#define DEMOCONTROLLER_H

#include "../mvc/BaseController.h"

class DemoModel;

/**
 * @brief 演示用的Controller类
 * 展示如何继承BaseController实现具体的控制器
 */
class DemoController : public BaseController
{
    Q_OBJECT

public:
    explicit DemoController(QObject *parent = nullptr);

    // 实现基类的纯虚函数
    void handleWebViewMessage(const QString& method, const QJsonObject& params) override;
    void initialize() override;

private slots:
    void onWebViewReady();

private:
    // 消息处理方法
    void handleTestConnection(const QJsonObject& params);
    void handlePing(const QJsonObject& params);
    void handleGetSystemInfo(const QJsonObject& params);
    void handleSaveData(const QJsonObject& params);
    void handleLoadData(const QJsonObject& params);
    void handleDeleteData(const QJsonObject& params);
    void handleBridgeReady(const QJsonObject& params);

    DemoModel* getDemoModel() const;
};

#endif // DEMOCONTROLLER_H