# WebView 调试功能使用说明

本文档说明如何在 GGTPassword 应用程序中启用和禁用 WebView 调试功能。

## 调试功能概述

WebView 调试功能允许您：
- 使用 Safari 开发者工具检查 WebView 内容
- 远程调试 WebView 中的 JavaScript 代码
- 查看网络请求和控制台输出
- 调试 HTML/CSS 布局问题

在 Windows 上，集成了 WebView2 的开发者工具，并在调试模式中自动开启。

## 启用调试功能

### 方法 1: 编译时启用（推荐）

1. 在项目根目录的 `CMakeLists.txt` 中设置 `DEBUG_MODE` 选项：
   ```cmake
   option(DEBUG_MODE "Enable debug mode" ON)
   ```

2. 或者在构建时通过命令行参数启用：
   ```bash
   cd build
   cmake .. -DDEBUG_MODE=ON
   make -j$(nproc)
   ```

### 方法 2: 运行时启用

使用命令行参数启动应用程序：
```bash
./GGTPassword.app/Contents/MacOS/GGTPassword --debug
```

## 禁用调试功能

### 方法 1: 编译时禁用

1. 在项目根目录的 `CMakeLists.txt` 中设置：
   ```cmake
   option(DEBUG_MODE "Enable debug mode" OFF)
   ```

2. 或者在构建时通过命令行参数禁用：
   ```bash
   cd build
   cmake .. -DDEBUG_MODE=OFF
   make -j$(nproc)
   ```

### 方法 2: 运行时禁用

使用命令行参数启动应用程序：
```bash
./GGTPassword.app/Contents/MacOS/GGTPassword --no-debug
```

## 使用 Safari 开发者工具调试

1. **启用 Safari 开发菜单**：
   - 打开 Safari 浏览器
   - 进入 Safari → 偏好设置 → 高级
   - 勾选"在菜单栏中显示开发菜单"

2. **连接到 WebView**：
   - 启动带有调试功能的 GGTPassword 应用程序
   - 在 Safari 中，点击菜单栏的"开发"
   - 找到 "GGTPassword" 或相应的应用程序名称
   - 选择要调试的 WebView 页面

3. **开始调试**：
   - Safari 开发者工具将打开
   - 您可以检查元素、查看控制台、调试 JavaScript 等

## 调试功能的技术实现

### 编译时配置
- `WEBVIEW_DEBUG_MODE` 宏控制调试功能的编译
- 当启用时，会包含 `DebugManager` 相关代码

### 运行时配置
- `DebugManager::initialize(bool debugMode)` 初始化调试状态
- `shouldEnableSafariDevTools()` 返回是否启用 Safari 开发者工具

### WebView 配置
- `developerExtrasEnabled` 启用开发者额外功能
- `setInspectable:YES` 启用远程检查（macOS 13.3+）
- Info.plist 中的 `WKWebViewDebuggingEnabled` 配置

## 在 Windows (WebView2) 上调试

1. 在 `CMakeLists.txt` 中启用 `DEBUG_MODE` 或通过命令行启用 `--debug`
2. 调试模式下，WebView2 将：
   - 使用独立的用户数据目录：`%LOCALAPPDATA%/GGT/GGTPassword/WebView2DebugProfile`
   - 自动启用并打开 DevTools
   - 启用右键菜单与脚本执行，便于排查问题
3. 如需查看控制台与网络面板，跟随自动弹出的 DevTools 窗口进行调试

注意：若需要远程调试端口（如 `--remote-debugging-port=9222`），需通过 `CoreWebView2EnvironmentOptions` 设置 `AdditionalBrowserArguments`。当前项目默认不启用该端口，但已预留统一的 `DebugManager` 入口，可按需扩展。

## 注意事项

1. **性能影响**：调试模式可能会影响应用程序性能，生产环境建议禁用
2. **安全考虑**：调试功能可能暴露应用程序内部信息，发布版本应禁用
3. **系统要求**：远程调试功能需要 macOS 13.3 或更高版本
4. **Safari 版本**：建议使用最新版本的 Safari 以获得最佳调试体验

## 故障排除

### 问题：Safari 开发菜单中看不到应用程序
**解决方案**：
1. 确认调试功能已正确启用
2. 检查 Safari 开发菜单是否已启用
3. 重启 Safari 浏览器
4. 确认应用程序正在运行且 WebView 已加载

### 问题：调试功能无法启用
**解决方案**：
1. 检查编译时是否正确设置了 `DEBUG_MODE`
2. 确认 `WEBVIEW_DEBUG_MODE` 宏已定义
3. 查看应用程序启动日志确认调试状态

### 问题：WebView 内容无法检查
**解决方案**：
1. 确认 WebView 已完全加载
2. 检查 Info.plist 中的 WebKit 配置
3. 尝试重新加载 WebView 内容

## 相关文件

- `debug/DebugManager.h` - 调试管理器头文件
- `debug/DebugManager.cpp` - 调试管理器实现
- `platform/macos/MacOSWebViewBridge.mm` - macOS WebView 桥接实现
- `Info.plist.in` - 应用程序配置模板
- `CMakeLists.txt` - 构建配置文件