@echo off
setlocal enabledelayedexpansion

echo ========================================
echo Windows CMake Configuration Script
echo ========================================

:: 设置编码为UTF-8
chcp 65001 > nul

:: 获取脚本所在目录
set "SCRIPT_DIR=%~dp0"
cd /d "%SCRIPT_DIR%"

:: 设置构建目录
set "BUILD_DIR=%SCRIPT_DIR%build_windows"

:: 检查CMake是否可用
where cmake >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] CMake not found in PATH. Please install CMake.
    pause
    exit /b 1
)

:: 检查Qt是否可用
where qmake >nul 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Qt not found in PATH. Please ensure Qt is installed.
    echo Example: set PATH=C:\Qt\6.x.x\msvc2019_64\bin;%%PATH%%
    pause
    exit /b 1
)

:: 获取Qt版本信息
for /f "tokens=*" %%i in ('qmake -query QT_VERSION') do set QT_VERSION=%%i
for /f "tokens=*" %%i in ('qmake -query QT_INSTALL_PREFIX') do set QT_DIR=%%i

echo [INFO] Qt Version: %QT_VERSION%
echo [INFO] Qt Directory: %QT_DIR%

:: 创建构建目录
if not exist "%BUILD_DIR%" (
    echo [INFO] Creating build directory: %BUILD_DIR%
    mkdir "%BUILD_DIR%"
)

cd /d "%BUILD_DIR%"

:: 设置CMake参数
set CMAKE_ARGS=-G "Visual Studio 17 2022" -A x64
set CMAKE_ARGS=%CMAKE_ARGS% -DCMAKE_BUILD_TYPE=Debug
set CMAKE_ARGS=%CMAKE_ARGS% -DCMAKE_PREFIX_PATH="%QT_DIR%"

:: 检查WebView2 SDK
set "WEBVIEW2_SDK=%SCRIPT_DIR%third_party\webview2"
if exist "%WEBVIEW2_SDK%\build\native\include\WebView2.h" (
    echo [INFO] Found WebView2 SDK at: %WEBVIEW2_SDK%
    set CMAKE_ARGS=%CMAKE_ARGS% -DWEBVIEW2_INCLUDE_DIR="%WEBVIEW2_SDK%\build\native\include"
) else (
    echo [WARNING] WebView2 SDK not found at expected location: %WEBVIEW2_SDK%
    echo [INFO] CMake will try to find WebView2 automatically
)

:: 运行CMake配置
echo [INFO] Running CMake configuration...
echo [INFO] Command: cmake .. %CMAKE_ARGS%
cmake .. %CMAKE_ARGS%

if %errorlevel% neq 0 (
    echo [ERROR] CMake configuration failed!
    echo.
    echo Possible solutions:
    echo 1. Ensure Visual Studio 2022 is installed with C++ development tools
    echo 2. Check Qt installation and PATH
    echo 3. Verify WebView2 SDK is properly extracted
    pause
    exit /b 1
)

echo [SUCCESS] CMake configuration completed successfully!
echo.
echo Next steps:
echo 1. Run: cmake --build . --config Debug
echo 2. Or use: msbuild GGTPassword.sln /p:Configuration=Debug
echo 3. Or run the build_windows.bat script
echo.
pause