#include "WebViewBridge.h"
#include <QDebug>

WebViewBridge::WebViewBridge(QObject *parent)
    : QObject(parent)
{
}

void WebViewBridge::setMessageHandler(MessageHandler handler)
{
    m_messageHandler = handler;
}

void WebViewBridge::handleMessage(const QString& message)
{
    qDebug() << "Received message from WebView:" << message;
    
    QJsonParseError error;
    QJsonDocument doc = QJsonDocument::fromJson(message.toUtf8(), &error);
    
    if (error.error != QJsonParseError::NoError) {
        qWarning() << "Failed to parse JSON message:" << error.errorString();
        return;
    }
    
    QJsonObject obj = doc.object();
    QString method = obj["method"].toString();
    QJsonObject params = obj["params"].toObject();
    
    if (method.isEmpty()) {
        qWarning() << "Message missing method field";
        return;
    }
    
    // 发射信号
    emit messageReceived(method, params);
    
    // 调用处理器
    if (m_messageHandler) {
        m_messageHandler(method, params);
    }
}

QJsonObject WebViewBridge::createResponse(const QString& method, const QJsonObject& data, 
                                         bool success, const QString& error)
{
    QJsonObject response;
    response["method"] = method;
    response["success"] = success;
    response["data"] = data;
    
    if (!error.isEmpty()) {
        response["error"] = error;
    }
    
    return response;
}