# GGTGenCode 模版代码生成工具

`gen_code` 是一个用于从模版快速生成新项目的脚本。它会拷贝指定模版中的示例工程到你的当前工作目录，重命名为你提供的新项目名，并对文件内容、文件名、目录名进行统一替换。

- 脚本位置：`./gen_code`
- 运行环境：macOS（使用 `bash`、`sed`、`find` 等常见工具）

## 快速开始

1. 赋予可执行权限：
   ```bash
   chmod +x gen_code
   ```
2. 在你希望生成项目的目录中执行（生成目录会创建在当前工作目录下）：
   ```bash
   /绝对路径/到/GGTGenCode/gen_code -t qtnativewebview -n MyApp
   ```
   或者在仓库根目录执行：
   ```bash
   ./gen_code -t qt -n MyQtApp
   ```

## 用法

```bash
./gen_code -t <template_name> -n <new_project_name>
```

- `-t, --template` 指定模版名称（当前支持：`qt`、`qtnativewebview`）
- `-n, --name` 指定新项目名称（例如：`MyApp`）
- `-h, --help` 显示帮助信息

示例：
```bash
./gen_code -t qtnativewebview -n MyApp
./gen_code -t qt -n MyQtApp
```

提示：生成的项目目录路径为 `$(pwd)/<new_project_name>`，建议在你希望生成的位置执行命令。

## 可用模版

模版目录结构：
```
templates/
  qt/
    GGTPassword/
  qtnativewebview/
    GGTPassword/
```

- 每个模版目录下必须包含示例工程目录 `GGTPassword`。
- 生成时会将该目录拷贝并重命名为你提供的 `-n` 名称。

## 工作原理

脚本会执行以下操作：
- 拷贝模版：将 `templates/<template>/GGTPassword` 复制到当前工作目录并重命名为 `-n` 指定的新目录。
- 替换内容：在多个常见文件类型中替换字符串：
  - 将 `GGTPassword` 替换为新项目名（区分大小写）。
  - 将小写的 `ggtpassword` 替换为新项目名的小写形式。
- 特殊替换（Bundle Identifier）：
  - `com.ggt.GGTPassword` → `com.ggt.<NewName>`
  - `com.joeyuan.ggtpassword` → `com.joeyuan.<newname>`（小写）
- 重命名文件/目录：
  - 若文件名或目录名包含 `GGTPassword` 或 `ggtpassword`，自动重命名为新名称对应的大小写形式。

参与内容替换的文件扩展名（节选）：
```
*.cpp *.h *.txt *.md *.sh *.js *.html *.plist *.in *.qrc *.conf *.mm *.bat *.xml *.java *.json
```

## 构建指南

生成完成后，脚本会在命令行展示下一步构建提示：
- 若模版为 `qtnativewebview`：
  - macOS: `./build.sh`
  - iOS: `./build_ios.sh`
- 若模版为 `qt`：
  ```bash
  mkdir build && cd build
  cmake .. && make
  ```

## 注意事项

- 仅在 macOS 上测试过，脚本使用了 `sed -i ''` 的 macOS 语法。
- 新项目名建议使用字母数字组合（避免空格和特殊字符），大小写会影响小写替换的结果。
- 目标目录必须不存在，否则脚本会报错退出。
- 可通过 `./gen_code -h` 查看帮助与当前可用模版列表。

## 扩展：新增模版

若你需要新增模版：
- 在 `templates/` 下创建新的模版目录，例如 `templates/mytemplate/`。
- 在该目录中放置示例工程目录 `GGTPassword/`（必需）。
- 运行命令时使用 `-t mytemplate` 即可生成。

---

如需在任何路径执行并在当前目录生成项目，可使用绝对路径调用脚本，例如：
```bash
/Users/yuanzhaoyi/Develop/github.com/Flyingon/GGTGenCode/gen_code -t qtnativewebview -n DemoApp
```